IF OBJECT_ID('P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE') IS NOT NULL
	DROP PROCEDURE [DBO].[P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE]
GO
--EXEC P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE 1,5,'2018-06-29'
CREATE PROCEDURE P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE @CD_EMP INT, @CD_FILIAL INT,@DT_PROC DATETIME=NULL AS 
BEGIN
DECLARE @CD_OCORRENCIA INT
DECLARE @CD_CONTROLE INT
DECLARE @CONTROLE INT
SET NOCOUNT ON
IF @DT_PROC IS NULL
BEGIN
	SET @DT_PROC= CONVERT(CHAR(10),GETDATE()-1,112)
END
Create table #RsVendas (CONTROLE INT IDENTITY (1,1),
						CD_EMP INT,
						CD_FILIAL INT,
						CD_CX INT,
						DT_MOV DATETIME,
						VLR_MOV MONEY,
						CD_CTR INT)
/*
	Inserir a ocorrencia de liberacao de final de semana
*/

	if Exists (select * from pdv_vd_fecha_mov
										where
										BLQ_ALT_FECHA =1
										and CD_EMP    = 1 
										AND CD_FILIAL = @CD_FILIAL 
										AND DT_MOV =@DT_PROC )
	begin
		Print 'Consta movimento de caixa bloqueado para o periodo e filial requisitado - P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE'
		Return;
	end


SET @CD_OCORRENCIA=ISNULL((SELECT CD_OCORRENCIA FROM GLB_OCORRENCIA WHERE TIPO_OCORRENCIA=1),0)

	IF @CD_OCORRENCIA=0
	BEGIN
		SET @CD_OCORRENCIA= ISNULL((SELECT Max(CD_OCORRENCIA) FROM GLB_OCORRENCIA),0)+1

		INSERT INTO GLB_OCORRENCIA(CD_OCORRENCIA,DS_OCORRENCIA,TIPO_OCORRENCIA)
		SELECT
			@CD_OCORRENCIA,
			'LIBERACAO DE MOVIMENTO COM DIFERENCA AUTOMATICO',
			1
	END

	SET @CD_OCORRENCIA=0
	SET @CD_OCORRENCIA=ISNULL((SELECT  CD_OCORRENCIA FROM GLB_OCORRENCIA WHERE TIPO_OCORRENCIA=2),0)

	IF @CD_OCORRENCIA=0
	BEGIN
		SET @CD_OCORRENCIA= ISNULL((SELECT Max(CD_OCORRENCIA) FROM GLB_OCORRENCIA),0)+1
	
		INSERT INTO GLB_OCORRENCIA(CD_OCORRENCIA,
									DS_OCORRENCIA,
									TIPO_OCORRENCIA)
		SELECT
			@CD_OCORRENCIA,
			'INFORMACAO DE FALTA DE CONSOLIDACAO (F8 - NO PDV)',
			2
	END

	INSERT INTO #RsVendas (CD_EMP, CD_FILIAL, CD_CX, DT_MOV, VLR_MOV, CD_CTR)
	SELECT 
		Rs.CD_EMP,
		Rs.CD_FILIAL,   
		Rs.CD_CX, 
		MAX(DT_VD) AS DT_VD,	
		SUM(VLR_LIQ_VD - VLR_ISSQN) AS VLR_LIQ_VD,
		0
	FROM (SELECT     
				CD_EMP,
				CD_FILIAL,       
				CD_CX,            
				VLR_LIQ_VD,           
				PDV_VD.DT_VD, 
					(SELECT ISNULL(SUM(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT), 0) AS VLR_LIQ_VD 
					FROM    
						PDV_VD_IT INNER JOIN EST_PROD ON    
						PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND    
						PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD 
					WHERE   
						PDV_VD.CD_VD = PDV_VD_IT.CD_VD AND    
						PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND   
						PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP    AND 
						PDV_VD.CD_EMP =@CD_EMP  
						AND PDV_VD.CD_FILIAL =@CD_FILIAL   
						AND PDV_VD.DT_VD =@DT_PROC   
						AND PDV_VD.ST_VD = 0  
						AND PDV_VD_IT.ST_IT = 1 
						AND  ISNULL(PDV_VD_IT.TIPO_IMPOSTO,0) = 1) AS VLR_ISSQN  
		FROM 
			PDV_VD  
		WHERE    
			CD_EMP =@CD_EMP  
			AND CD_FILIAL =@CD_FILIAL   
			AND DT_VD =@DT_PROC   
			AND ST_VD = 0) Rs 
	GROUP BY
		Rs.CD_EMP,
		Rs.CD_FILIAL,   
		Rs.CD_CX

--Remove caixas que nao existem.
	delete from a 
	from 
		#RsVendas a
		left join pdv_cx c on a.cd_emp = c.cd_emp and
		a.cd_cx = c.cd_cx
	where c.cd_emp is null;

--Se nao estiver faltando lancamento de leitura Z (F8 do PDV)
IF NOT EXISTS (select
					TOP 1 V.CD_EMP
			   from
					#RsVendas V LEFT OUTER JOIN PDV_CONSLD_VD ON
					V.CD_EMP = PDV_CONSLD_VD.CD_EMP AND
					V.CD_FILIAL = PDV_CONSLD_VD.CD_FILIAL AND
					V.CD_CX = PDV_CONSLD_VD.CD_CX AND
					V.DT_MOV = PDV_CONSLD_VD.DT_MOV
				WHERE
					PDV_CONSLD_VD.DT_MOV IS NULL)
BEGIN

	SET @CD_OCORRENCIA=ISNULL((SELECT CD_OCORRENCIA FROM GLB_OCORRENCIA WHERE TIPO_OCORRENCIA=1),0)
	--Movimento com diferenca de matriz e filial
	DECLARE CAnaliseVendasImp CURSOR FAST_FORWARD FOR 
	select
		v.CONTROLE
	from
		#RsVendas V 
		INNER JOIN PDV_CONSLD_VD ON
		V.CD_EMP = PDV_CONSLD_VD.CD_EMP AND
		V.CD_FILIAL = PDV_CONSLD_VD.CD_FILIAL AND
		V.CD_CX = PDV_CONSLD_VD.CD_CX AND
		V.DT_MOV = PDV_CONSLD_VD.DT_MOV
		LEFT OUTER JOIN PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO ON
		V.CD_EMP = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_EMP AND
		V.CD_FILIAL = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_FILIAL AND
		V.CD_CX =PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_CX AND
		V.DT_MOV = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV 
		LEFT JOIN PDV_CX C ON V.CD_EMP = C.CD_EMP AND
		V.CD_CX = C.CD_CX
	WHERE
		PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV IS NULL
		AND (V.VLR_MOV - PDV_CONSLD_VD.VLR_VD_LIQ)<>0
		AND C.CD_EMP IS NULL;
			
	OPEN CAnaliseVendasImp
	FETCH NEXT FROM CAnaliseVendasImp INTO @CONTROLE
		WHILE @@FETCH_STATUS=0
			begin
				SET @CD_CONTROLE= ISNULL((SELECT Max(CD_CTR) FROM PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO),0) + 1

				INSERT INTO PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO( CD_CTR
																,CD_EMP
																,CD_FILIAL
																,CD_CX
																,DT_MOV
																,CD_OCORRENCIA
																,HIST_CPL
																,CD_USU
																,DT_CAD
																,FLAG_SOLUCAO
																,DT_SOLUCAO
																,FLAG_LIBERA_LEITURA_Z)
				SELECT
					 @CD_CONTROLE
					,V.CD_EMP
					,V.CD_FILIAL
					,V.CD_CX
					,V.DT_MOV
					,@CD_OCORRENCIA
					,'LIBERACAO DE MOVIMENTO COM DIFERENCA LEITURA Z JA INFORMADA' AS HIST_CPL
					,1
					,GETDATE()
					,0
					,NULL
					,1
				FROM
						#RsVendas AS V
				WHERE v.controle=@controle;

				FETCH NEXT FROM CAnaliseVendasImp INTO @CONTROLE
			end
		CLOSE CAnaliseVendasImp;
		DEALLOCATE CAnaliseVendasImp;

	END

	--Se nao estiver faltando lancamento de leitura Z (F8 do PDV)
	IF EXISTS (select
						TOP 1 V.CD_EMP
				   from
						#RsVendas V LEFT OUTER JOIN PDV_CONSLD_VD ON
						V.CD_EMP = PDV_CONSLD_VD.CD_EMP AND
						V.CD_FILIAL = PDV_CONSLD_VD.CD_FILIAL AND
						V.CD_CX = PDV_CONSLD_VD.CD_CX AND
						V.DT_MOV = PDV_CONSLD_VD.DT_MOV
					WHERE
						PDV_CONSLD_VD.DT_MOV IS NULL)
	BEGIN
	
		SET @CD_OCORRENCIA=ISNULL((SELECT CD_OCORRENCIA FROM GLB_OCORRENCIA WHERE TIPO_OCORRENCIA=2),0)

		--Movimento com diferenca de matriz e filial
		DECLARE CAnaliseVendasImpNaoInformada CURSOR FAST_FORWARD FOR 
		select
			v.CONTROLE
		from
			#RsVendas V 
			LEFT OUTER JOIN PDV_CONSLD_VD ON
			V.CD_EMP = PDV_CONSLD_VD.CD_EMP AND
			V.CD_FILIAL = PDV_CONSLD_VD.CD_FILIAL AND
			V.CD_CX = PDV_CONSLD_VD.CD_CX AND
			V.DT_MOV = PDV_CONSLD_VD.DT_MOV
			LEFT OUTER JOIN PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO ON
			V.CD_EMP = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_EMP AND
			V.CD_FILIAL = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_FILIAL AND
			V.CD_CX =PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_CX AND
			V.DT_MOV = PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV 
			LEFT JOIN PDV_CX C ON V.CD_EMP = C.CD_EMP AND
			V.CD_CX = C.CD_CX
		WHERE
			PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV IS NULL
			AND PDV_CONSLD_VD.DT_MOV IS NULL
			AND C.CD_EMP IS NULL;
			
		OPEN CAnaliseVendasImpNaoInformada
		FETCH NEXT FROM CAnaliseVendasImpNaoInformada INTO @CONTROLE
		WHILE @@FETCH_STATUS=0
		  begin
			SET @CD_CONTROLE= ISNULL((SELECT
										Max(CD_CTR)
										FROM
										PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO),0) + 1

			INSERT INTO PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO( CD_CTR
																	,CD_EMP
																	,CD_FILIAL
																	,CD_CX
																	,DT_MOV
																	,CD_OCORRENCIA
																	,HIST_CPL
																	,CD_USU
																	,DT_CAD
																	,FLAG_SOLUCAO
																	,DT_SOLUCAO
																	,FLAG_LIBERA_LEITURA_Z)
			SELECT
				 @CD_CONTROLE
				,V.CD_EMP
				,V.CD_FILIAL
				,V.CD_CX
				,V.DT_MOV
				,@CD_OCORRENCIA
				,'FALTA DE FECHAMENTO DE MOVIMENTO (F8 - PDV)' AS HIST_CPL
				,1
				,GETDATE()
				,0
				,NULL
				,0
			FROM
				 #RsVendas AS V
			WHERE v.controle=@controle;

			FETCH NEXT FROM CAnaliseVendasImpNaoInformada INTO @CONTROLE
		  end
	   
		CLOSE CAnaliseVendasImpNaoInformada;
		DEALLOCATE CAnaliseVendasImpNaoInformada;
		PRINT 'Concluido.'

	END

	IF EXISTS(SELECT
				TOP 1 CD_CTR
			  FROM
				PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO
			  WHERE
				CD_EMP=@CD_EMP
				AND CD_FILIAL=@CD_FILIAL
				AND PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.FLAG_SOLUCAO=0)
	BEGIN
		--Movimento corrigido
		truncate table #RsVendas

		INSERT INTO #RsVendas (CD_EMP,
								CD_FILIAL,
								CD_CX,
								DT_MOV,
								VLR_MOV,
								CD_CTR)
		SELECT
			Rs.CD_EMP
			,Rs.CD_FILIAL
			,Rs.CD_CX
			,MAX(DT_VD) AS DT_VD
			,SUM(VLR_LIQ_VD-VLR_ISSQN) AS VLR_LIQ_VD
			,PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_CTR
		FROM
			(
				SELECT
					CD_EMP
					,CD_FILIAL
					,CD_CX
					,VLR_LIQ_VD
					,PDV_VD.DT_VD
					, (
							SELECT
								ISNULL(SUM(PDV_VD_IT.TOT_IT-PDV_VD_IT.VLR_DESC_TOT_RAT),0) AS VLR_LIQ_VD
							FROM
								PDV_VD_IT
							INNER JOIN EST_PROD ON PDV_VD_IT.CD_EMP=EST_PROD.CD_EMP
													AND PDV_VD_IT.CD_PROD=EST_PROD.CD_PROD
							WHERE PDV_VD.CD_VD=PDV_VD_IT.CD_VD
								AND PDV_VD.CD_FILIAL=PDV_VD_IT.CD_FILIAL
								AND PDV_VD.CD_EMP=PDV_VD_IT.CD_EMP
								AND PDV_VD.CD_EMP=@CD_EMP
								AND PDV_VD.CD_FILIAL=@CD_FILIAL
								AND PDV_VD.ST_VD=0
								AND PDV_VD_IT.ST_IT=1
								AND ISNULL(PDV_VD_IT.TIPO_IMPOSTO,0)=1
						) AS VLR_ISSQN
				FROM
					PDV_VD
				WHERE CD_EMP=@CD_EMP
					AND CD_FILIAL=@CD_FILIAL
					AND ST_VD=0) AS Rs
			INNER JOIN PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO ON Rs.CD_EMP=PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_EMP
														AND Rs.CD_FILIAL=PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_FILIAL
														AND Rs.CD_CX=PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_CX
														AND Rs.DT_VD=PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV
		WHERE PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.FLAG_SOLUCAO=0
		GROUP BY
				Rs.CD_EMP
			,Rs.CD_FILIAL
			,Rs.CD_CX
			,PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_CTR;

		DECLARE CAnaliseVendasResolvido CURSOR FAST_FORWARD
		FOR SELECT
				 V.CD_CTR
			FROM
				 #RsVendas AS V
				 INNER JOIN PDV_CONSLD_VD ON V.CD_EMP=PDV_CONSLD_VD.CD_EMP
										AND V.CD_FILIAL=PDV_CONSLD_VD.CD_FILIAL
										AND V.CD_CX=PDV_CONSLD_VD.CD_CX
										AND V.DT_MOV=PDV_CONSLD_VD.DT_MOV
			WHERE(V.VLR_MOV=PDV_CONSLD_VD.VLR_VD_LIQ)
			UNION ALL
			SELECT
				 V.CD_CTR
			FROM
				#RSVENDAS AS V
				INNER JOIN PDV_CONSLD_VD ON V.CD_EMP=PDV_CONSLD_VD.CD_EMP
										AND V.CD_FILIAL=PDV_CONSLD_VD.CD_FILIAL
										AND V.CD_CX=PDV_CONSLD_VD.CD_CX
										AND V.DT_MOV=PDV_CONSLD_VD.DT_MOV
			WHERE(V.VLR_MOV<>PDV_CONSLD_VD.VLR_VD_LIQ);

			OPEN CAnaliseVendasResolvido;
			FETCH NEXT FROM CAnaliseVendasResolvido INTO @CONTROLE;

			WHILE @@FETCH_STATUS=0
			BEGIN
				UPDATE PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO
				SET
					FLAG_SOLUCAO=1
				   ,DT_SOLUCAO=GETDATE()
				WHERE
					 CD_CTR=@CONTROLE;
				FETCH NEXT FROM CAnaliseVendasResolvido INTO @CONTROLE;
			END;

			CLOSE CAnaliseVendasResolvido; 
			DEALLOCATE CAnaliseVendasResolvido;
		END
	
		DROP TABLE #RsVendas
	END